IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CTB_CNT_DRE_RESULTADO]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[CTB_CNT_DRE_RESULTADO](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[ANO] [int] NOT NULL,
	[MES] [int] NOT NULL,
	[TP_DRE] [int] NOT NULL,
	[TP_RAT_CENTO_CUSTO] [int] NOT NULL,
	[NIVEL_CNT_DRE] [varchar](40) NOT NULL,
	[CD_OP_CNT_DRE] [int] NOT NULL,
	[IS_FORMULA] [int] NOT NULL,
	[DS_CNT_DRE] [varchar](100) NOT NULL,
	[VLR_MES_ANO_PAS] [money] NOT NULL,
	[VLR_ACUM_ANO_PAS] [money] NOT NULL,
	[VLR_MES_ANT] [money] NOT NULL,
	[VLR_MES_ATU] [money] NOT NULL,
	[VLR_ACUM_ATU] [money] NOT NULL,
	[NIVEL_BASE_PERC_VERT] [varchar](40) NOT NULL,
	[PERC_HORZ_ACUM_ANO_PAS] [money] NOT NULL,
	[PERC_HORZ_MES_ANO_PAS] [money] NOT NULL,
	[PERC_HORZ_MES_ANT] [money] NOT NULL,
	[PERC_VERT_MES_ANT] [money] NOT NULL,
	[PERC_VERT_MES_ATU] [money] NOT NULL,
	[DT_BASE] [datetime] NOT NULL,
	[DT_MES_ANT] [datetime] NOT NULL,
	[ANO_PAS] [int] NOT NULL,
	[FLAG_SINAL] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_CTB_CNT_DRE_RESULTADO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_CTB_CNT_DRE_RESULTADO] UNIQUE NONCLUSTERED 
(
	[MES] ASC,
	[CD_FILIAL] ASC,
	[ANO] ASC,
	[TP_DRE] ASC,
	[TP_RAT_CENTO_CUSTO] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_ANO]  DEFAULT ((0)) FOR [ANO]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_MES]  DEFAULT ((0)) FOR [MES]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_TP_DRE]  DEFAULT ((0)) FOR [TP_DRE]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_TP_RAT_CENTO_CUSTO]  DEFAULT ((0)) FOR [TP_RAT_CENTO_CUSTO]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_NIVEL_CNT_DRE]  DEFAULT ('') FOR [NIVEL_CNT_DRE]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_CD_OP_CNT_DRE]  DEFAULT ((0)) FOR [CD_OP_CNT_DRE]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_IS_FORMULA]  DEFAULT ((0)) FOR [IS_FORMULA]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_DS_CNT_DRE]  DEFAULT ('') FOR [DS_CNT_DRE]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_VLR_MES_ANO_PAS]  DEFAULT ((0)) FOR [VLR_MES_ANO_PAS]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_VLR_ACUM_ANO_PAS]  DEFAULT ((0)) FOR [VLR_ACUM_ANO_PAS]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_VLR_MES_ANT]  DEFAULT ((0)) FOR [VLR_MES_ANT]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_VLR_MES_ATU]  DEFAULT ((0)) FOR [VLR_MES_ATU]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_VLR_ACUM_ATU]  DEFAULT ((0)) FOR [VLR_ACUM_ATU]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_NIVEL_BASE_PERC_VERT]  DEFAULT ('') FOR [NIVEL_BASE_PERC_VERT]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_PERC_HORZ_ACUM_ANO_PAS]  DEFAULT ((0)) FOR [PERC_HORZ_ACUM_ANO_PAS]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_PERC_HORZ_MES_ANO_PAS]  DEFAULT ((0)) FOR [PERC_HORZ_MES_ANO_PAS]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_PERC_HORZ_MES_ANT]  DEFAULT ((0)) FOR [PERC_HORZ_MES_ANT]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_PERC_VERT_MES_ANT]  DEFAULT ((0)) FOR [PERC_VERT_MES_ANT]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_PERC_VERT_MES_ATU]  DEFAULT ((0)) FOR [PERC_VERT_MES_ATU]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_ANO_PAS]  DEFAULT ((0)) FOR [ANO_PAS]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_FLAG_SINAL]  DEFAULT ((0)) FOR [FLAG_SINAL]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CTB_CNT_DRE_RESULTADO] ADD  CONSTRAINT [DF_CTB_CNT_DRE_RESULTADO_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]
END
